<?php
// ===============================================
//  Очередь к врачам с маскировкой персональных данных
//  Автор: Виталий (it-crowd.by)
//
//  История версий:
//  3.0  — базовая реализация: загрузка таблицы из CRM, автообновление, маскирование ФИО
//  3.2  — добавлены параметры clinic_id и режим mode=clean
//  3.4  — реализовано выделение экстренных пациентов и предупреждающая плашка
//  3.4.1 — уведомление об экстренном пациенте перемещено вверх, уменьшена высота плашки, улучшен цвет жёлтых строк
//
//  Версия: 3.4.1 — уведомление о экстренном пациенте перемещено вверх и уменьшено по высоте
// ===============================================

// === Настройки подключения к CRM Vetmanager ===

// Домен вашей CRM Vetmanager.
// Например: clinicname.vetmanager.ru, clinicname.vetmanager2.ru или vetmanager.yourdomain.by (локальный сервер)
$crmDomain = 'clinicname.vetmanager.ru';

// API-ключ Vetmanager.
// Получить можно в CRM: Настройки → Интеграция с сервисами → REST API
$apiKey = '456416878972654165415614';

// Список скрываемых статусов (в данном случае скрываем номер клиента и время ожидания).
// В большинстве случаев достаточно оставить '1,8'
$hide = '1,8';

// ===============================================

// Параметры, задаваемые через URL
$clinicId = isset($_GET['clinic_id']) ? intval($_GET['clinic_id']) : 1;       // номер клиники
$cleanMode = isset($_GET['mode']) && $_GET['mode'] === 'clean';              // режим clean — без бегущей строки
$emergencyHighlight = !isset($_GET['emerg']) || $_GET['emerg'] != '0';       // emerg=0 отключает подсветку экстренных пациентов

// Формирование исходного URL CRM-страницы
$source = sprintf(
    'https://%s/queue-for-doctors.php?key=%s&clinic_id=%d&hide=%s',
    $crmDomain,
    $apiKey,
    $clinicId,
    $hide
);

// Режим AJAX-запроса: только обновление таблицы без перезагрузки страницы
if (isset($_GET['ajax']) && $_GET['ajax'] == '1') {
    $ch = curl_init($source);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);
    $html = curl_exec($ch);
    curl_close($ch);

    // Маскирование ФИО клиентов
    $html = preg_replace_callback(
        '/([А-ЯЁ][а-яё\-]+)\s+([А-ЯЁ])[а-яё]+(?:\s+([А-ЯЁ])[а-яё]+)?/u',
        function ($m) {
            $ln = trim($m[1]);
            $fi = $m[2];
            $mi = isset($m[3]) ? $m[3] : '';
            $len = mb_strlen($ln, 'UTF-8');
            if ($len > 3) {
                $masked = mb_substr($ln, 0, 2) . str_repeat('*', $len - 3) . mb_substr($ln, -1);
            } else {
                $masked = mb_substr($ln, 0, 1) . '*' . mb_substr($ln, -1, 1);
            }
            return trim("$masked $fi." . ($mi ? " $mi." : ""));
        },
        $html
    );

    // Извлечение таблицы из HTML Vetmanager
    if (preg_match('/<table[^>]*>.*<\/table>/isU', $html, $matches)) {
        echo $matches[0];
    } else {
        echo 'Ошибка загрузки данных.';
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
<meta charset="UTF-8">
<title>Очередь к врачам — Клиника №<?= htmlspecialchars($clinicId) ?></title>
<style>
    body {
        font-family: "Segoe UI", sans-serif;
        font-size: 18px;
        background: #fafafa;
        margin: 0;
        padding: 10px;
        position: relative;
        min-height: 100vh;
    }
    table { border-collapse: collapse; width: 100%; }
    td, th { padding: 3px 6px; border-bottom: 1px solid #ddd; line-height: 1.1; }
    thead tr td {
        background: #EDEEF0; font-weight: 600; border-bottom: 2px solid #ccc;
    }
    td.b-waiting-table__at_the_doctor {
        background: #EDEEF0; font-weight: 600; border-bottom: 2px solid #ccc;
        text-align: left; padding: 5px 6px; font-size: 18px;
    }

    /* Цветовое оформление строк */
    tr.critical-state-row { background: #ffe0e0; }
    tr.warning-state-row  { background: #FFFFCC; }   /* жёлтый (внимание) — более контрастный */
    tr.normal-state-row   { background: #dfffdc; }
    tr.unknown-state-row  { background: #f9f9f9; }

    /* Плашка уведомления об экстренном пациенте */
    #emergency-alert {
        display:none;
        width:100%;
        background:#fff3cd;
        color:#7a5500;
        text-align:center;
        font-size:18px;      /* было 20px → уменьшено на 10 % */
        font-weight:600;
        padding:8px 0;       /* было 10px → уменьшено на 20 % */
        border-bottom:2px solid #ffcc00;
        box-shadow:0 2px 6px rgba(0,0,0,0.1);
        margin-bottom:10px;
    }

<?php if (!$cleanMode): ?>
    /* Нижняя панель с часами и бегущей строкой */
    #footer-bar {
        position: fixed;
        bottom: 10px; left: 15px; right: 15px;
        display: flex; justify-content: space-between; align-items: center;
        color: #444; font-size: 22px; font-weight: 500;
        font-family: "Segoe UI", sans-serif;
        opacity: 0.9; overflow: hidden;
    }
    #clock { white-space: nowrap; flex-shrink: 0; }
    #ticker {
        flex: 1; margin-left: 30px; overflow: hidden; white-space: nowrap;
    }
    #ticker span {
        display: inline-block; padding-left: 100%;
        animation: ticker 55s linear infinite;
    }
    #ticker:hover span { animation-play-state: paused; }
    @keyframes ticker {
        0% { transform: translateX(0); }
        100% { transform: translateX(-100%); }
    }
<?php endif; ?>
</style>

<script>
// === Автообновление таблицы каждые 20 секунд ===
async function refreshTable() {
    try {
        const response = await fetch("?ajax=1&clinic_id=<?= $clinicId ?>&_" + Date.now());
        const html = await response.text();
        document.getElementById("queue-table").innerHTML = html;
        <?php if ($emergencyHighlight): ?>highlightEmergency();<?php endif; ?>
    } catch (e) {
        console.error("Ошибка обновления данных:", e);
    }
}
setInterval(refreshTable, 20000);
window.addEventListener("load", refreshTable);

<?php if (!$cleanMode): ?>
// === Часы в нижней панели ===
function updateClock() {
    const now = new Date();
    const options = { weekday:"short", year:"numeric", month:"short", day:"numeric" };
    const date = now.toLocaleDateString("ru-RU", options);
    const time = now.toLocaleTimeString("ru-RU",{hour:"2-digit", minute:"2-digit"});
    document.getElementById("clock").textContent = date + " • " + time;
}
setInterval(updateClock, 1000);
window.onload = updateClock;
<?php endif; ?>
</script>
</head>
<body>

<!-- ⚡ Плашка для экстренных пациентов (расположена над таблицей) -->
<div id="emergency-alert"></div>

<!-- Таблица очереди -->
<div id="queue-table">Загрузка данных...</div>

<?php if (!$cleanMode): ?>
<!-- Нижняя панель с часами и бегущей строкой -->
<div id="footer-bar">
    <div id="clock"></div>
    <div id="ticker">
        <span>
        Уважаемые клиенты, прием врача осуществляется по предварительной записи. 
        Экстренные пациенты всегда принимаются вне очереди. 
        Время записи является приблизительным, так как всего один экстренный пациент может сдвинуть все последующие записи. 
        Благодарим за понимание! | 
        Экономьте время! Онлайн запись на сайте alfavet.by - это удобный и быстрый способ записаться на прием. 
        Вы сможете увидеть график работы нужного специалиста, выбрать специализацию и ближайшую клинику. 
        Ждём вас на сайте alfavet.by!
        </span>
    </div>
</div>
<?php endif; ?>

<?php if ($emergencyHighlight): ?>
<script>
// === Подсветка экстренных пациентов ===
function highlightEmergency() {
  let hasEmergency = false;
  const alertBar = document.getElementById("emergency-alert");
  document.querySelectorAll("#queue-table tr").forEach(tr => {
    const text = tr.textContent.toLowerCase();
    if (text.includes("экстрен")) {
      hasEmergency = true;
      tr.style.backgroundColor = "#ffe8c6";
      tr.style.fontWeight = "600";
      tr.style.borderLeft = "6px solid #ffa500";
      const goalCell = tr.querySelector("td:nth-child(3)");
      if (goalCell && !goalCell.innerHTML.includes("⚡")) {
        goalCell.innerHTML = "⚡ " + goalCell.innerHTML;
      }
    } else {
      tr.style.borderLeft = "";
    }
  });

  if (hasEmergency) {
    alertBar.innerHTML = "⚡ На приёме экстренный пациент. Время ожидания может быть увеличено.";
    alertBar.style.display = "block";
  } else {
    alertBar.style.display = "none";
  }
}
setInterval(highlightEmergency, 2000);
highlightEmergency();
</script>
<?php endif; ?>

</body>
</html>
